/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.query.VWIndexPanel;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

class VWIndexDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private VWIndexPanel m_indexPanel = null;
    private VWExposedFieldDefinition[] m_exposedFields = null;
    private Object[] m_minValues = null;
    private Object[] m_maxValues = null;
    private int m_queryFlags = 0;

    public VWIndexDialog(Dialog parent) {
        super(parent);
        this.layoutControls();
    }

    public VWIndexDialog(Frame parent) {
        super(parent);
        this.layoutControls();
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_cancelButton != null) {
            this.m_cancelButton.requestFocus();
        } else if (this.m_okButton != null) {
            this.m_okButton.requestFocus();
        } else if (this.m_helpButton != null) {
            this.m_helpButton.requestFocus();
        }
    }

    public void removeReferences() {
        int i;
        super.removeReferences();
        if (this.m_exposedFields != null) {
            for (i = 0; i < this.m_exposedFields.length; ++i) {
                this.m_exposedFields[i] = null;
            }
            this.m_exposedFields = null;
        }
        if (this.m_minValues != null) {
            for (i = 0; i < this.m_minValues.length; ++i) {
                this.m_minValues[i] = null;
            }
            this.m_minValues = null;
        }
        if (this.m_maxValues != null) {
            for (i = 0; i < this.m_maxValues.length; ++i) {
                this.m_maxValues[i] = null;
            }
            this.m_maxValues = null;
        }
        this.m_indexPanel = null;
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_okButton) {
            this.m_indexPanel.stopEditing();
            if (this.m_indexPanel.getErrorValidatingFlag()) {
                this.m_indexPanel.setErrorValidatingFlag(false);
                return;
            }
            this.m_nExitStatus = 0;
            this.setVisible(false);
        } else if (event.getSource() == this.m_cancelButton) {
            this.setVisible(false);
            this.m_indexPanel.stopEditing();
            this.m_indexPanel.setQueryFlags(this.m_queryFlags);
            this.m_indexPanel.setMinValues(this.m_minValues);
            this.m_indexPanel.setMaxValues(this.m_maxValues);
        } else if (event.getSource() == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah039.htm");
        }
    }

    protected String getIndexName() {
        return this.m_indexPanel.getIndexName();
    }

    protected int getQueryFlags() {
        return this.m_indexPanel.getQueryFlags();
    }

    protected Object[] getMaxValues() {
        return this.m_indexPanel.getMaxValues();
    }

    protected Object[] getMinValues() {
        return this.m_indexPanel.getMinValues();
    }

    protected void setExposedFields(VWExposedFieldDefinition[] exposedFields) {
        this.m_exposedFields = exposedFields;
    }

    protected void resetTable(VWIndexDefinition indexDef) {
        this.m_indexPanel.resetTable(indexDef, this.m_exposedFields);
    }

    protected void setDefaults() {
        this.m_queryFlags = this.m_indexPanel.getQueryFlags();
        this.m_minValues = this.m_indexPanel.getMinValues();
        this.m_maxValues = this.m_indexPanel.getMaxValues();
    }

    private void layoutControls() {
        try {
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            Dimension dim = VWStringUtils.stringToDimension("555,225");
            if (dim == null) {
                dim = new Dimension(500, 200);
            }
            this.setSize(dim.width, dim.height);
            this.setTitle(VWResource.s_indexDlgTitle);
            this.setVisible(false);
            this.initializeContentPane();
            this.addWindowListener(new VWWindowAdapter(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initializeContentPane() {
        try {
            this.m_indexPanel = new VWIndexPanel();
            this.getContentPane().add((Component)this.m_indexPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

